unit Stats;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     Gauges, 
     ExtCtrls, 
     NWlib, 
     nwServer,
     nwTools;

type
  TwinStats = class(TForm)
    CancelBtn: TBitBtn;
    Timer1: TTimer;
    statPanel: TPanel;
    sftLevel: TEdit;
    ttsLevel: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    serverVer: TEdit;
    Label9: TLabel;
    NumVolumes: TEdit;
    maxConns: TEdit;
    connsInUse: TEdit;
    peakConns: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Stats: TGroupBox;
    packetsOut: TEdit;
    upTime: TEdit;
    packetsIn: TEdit;
    Label6: TLabel;
    Label5: TLabel;
    Label1: TLabel;
    Panel2: TPanel;
    gUtilization: TGauge;
    Label2: TLabel;
    cache: TGroupBox;
    cacheHits: TEdit;
    writeBlockCount: TEdit;
    diskWriteCount: TEdit;
    numDirtyCacheHits: TEdit;
    cacheDirtyWaitTime: TEdit;
    cacheMaxConcurrent: TEdit;
    maxByteCount: TEdit;
    minCacheBuffers: TEdit;
    Label14: TLabel;
    Label20: TLabel;
    Label19: TLabel;
    Label18: TLabel;
    Label17: TLabel;
    Label16: TLabel;
    Label15: TLabel;
    Label21: TLabel;
    NWServer1: TNWServer;
    NWTools1: TNWTools;
    NWLib1: TNWLib;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    function UpdateStats : boolean ;
  public
    { Public declarations }
  end;

var
  winStats: TwinStats;

implementation

{$R *.DFM}

procedure TwinStats.FormShow(Sender: TObject);
  begin
    updateStats;
  end;

function TwinStats.UpdateStats : boolean ;
  var
    serverStats  : TNWServerInfo ;
    memCacheInfo : TNWMemCacheInfo ;
  begin
    try
      { Get Server's Operational & I/O Statistics }
      if getServerStats(getPrimaryServerID, serverStats) then
        begin
          gUtilization.progress := serverStats.utilization ;
          packetsIn.text   := intToStr(serverStats.packetsIn)    ; 
          packetsOut.text  := intToStr(serverStats.packetsOut)   ;
          serverVer.text   := serverStats.version                ;
          sftLevel.text    := intToStr(serverStats.sftlevel)     ;
          ttsLevel.text    := intToStr(serverStats.ttsLevel)     ;
          numVolumes.text  := intToStr(serverStats.numVolumes)   ;
          maxConns.text    := intToStr(serverStats.maxConns)     ;
          connsInUse.text  := intToStr(serverStats.connsInUse)   ;
          peakConns.text   := intToStr(serverStats.maxConnsUsed) ;
          upTime.text      := ticksToTimeString(serverStats.serverUpTime) ;
        end;  
      
      { Retrieve Server's File System Counters }
      if getCacheInfo(GetPrimaryServerID,memCacheInfo) then
        begin
          cacheHits.text          := intToStr(memCacheInfo.numCacheHits)     ;
          writeBlockCount.text    := intToStr(memCacheInfo.writeBlockCount)      ;
          diskWriteCount.text     := intToStr(memCacheInfo.diskWriteCount)    ;
          numDirtyCacheHits.text  := intToStr(memCacheInfo.numDirtyCacheHits) ;
          cacheDirtyWaitTime.text := intToStr(memCacheInfo.cacheDirtyWaitTime);
          cacheMaxConcurrent.text := intToStr(memCacheInfo.cacheMaxConcurrentWrites)    ;
          maxByteCount.text       := intToStr(memCacheInfo.maxByteCount)     ;
          minCacheBuffers.text    := intToStr(memCacheInfo.minCacheBuffers)        ;
        end;
      result := true ; 
    except
      result := false ;
    end;    
  end;


procedure TwinStats.Timer1Timer(Sender: TObject);
  begin
    timer1.enabled := updateStats ;
  end;

end.
